import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeletePublicAccessBlockRequest } from "../models/models_0";
import { deserializeAws_restXmlDeletePublicAccessBlockCommand, serializeAws_restXmlDeletePublicAccessBlockCommand, } from "../protocols/Aws_restXml";
var DeletePublicAccessBlockCommand = (function (_super) {
    __extends(DeletePublicAccessBlockCommand, _super);
    function DeletePublicAccessBlockCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeletePublicAccessBlockCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "DeletePublicAccessBlockCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeletePublicAccessBlockRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeletePublicAccessBlockCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlDeletePublicAccessBlockCommand(input, context);
    };
    DeletePublicAccessBlockCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlDeletePublicAccessBlockCommand(output, context);
    };
    return DeletePublicAccessBlockCommand;
}($Command));
export { DeletePublicAccessBlockCommand };
