import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteObjectTaggingOutput, DeleteObjectTaggingRequest } from "../models/models_0";
import { deserializeAws_restXmlDeleteObjectTaggingCommand, serializeAws_restXmlDeleteObjectTaggingCommand, } from "../protocols/Aws_restXml";
var DeleteObjectTaggingCommand = (function (_super) {
    __extends(DeleteObjectTaggingCommand, _super);
    function DeleteObjectTaggingCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteObjectTaggingCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "DeleteObjectTaggingCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteObjectTaggingRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteObjectTaggingOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteObjectTaggingCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlDeleteObjectTaggingCommand(input, context);
    };
    DeleteObjectTaggingCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlDeleteObjectTaggingCommand(output, context);
    };
    return DeleteObjectTaggingCommand;
}($Command));
export { DeleteObjectTaggingCommand };
