import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteObjectOutput, DeleteObjectRequest } from "../models/models_0";
import { deserializeAws_restXmlDeleteObjectCommand, serializeAws_restXmlDeleteObjectCommand, } from "../protocols/Aws_restXml";
var DeleteObjectCommand = (function (_super) {
    __extends(DeleteObjectCommand, _super);
    function DeleteObjectCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteObjectCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "DeleteObjectCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteObjectRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DeleteObjectOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteObjectCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlDeleteObjectCommand(input, context);
    };
    DeleteObjectCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlDeleteObjectCommand(output, context);
    };
    return DeleteObjectCommand;
}($Command));
export { DeleteObjectCommand };
