import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteBucketWebsiteRequest } from "../models/models_0";
import { deserializeAws_restXmlDeleteBucketWebsiteCommand, serializeAws_restXmlDeleteBucketWebsiteCommand, } from "../protocols/Aws_restXml";
var DeleteBucketWebsiteCommand = (function (_super) {
    __extends(DeleteBucketWebsiteCommand, _super);
    function DeleteBucketWebsiteCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteBucketWebsiteCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "DeleteBucketWebsiteCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteBucketWebsiteRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteBucketWebsiteCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlDeleteBucketWebsiteCommand(input, context);
    };
    DeleteBucketWebsiteCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlDeleteBucketWebsiteCommand(output, context);
    };
    return DeleteBucketWebsiteCommand;
}($Command));
export { DeleteBucketWebsiteCommand };
