import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteBucketReplicationRequest } from "../models/models_0";
import { deserializeAws_restXmlDeleteBucketReplicationCommand, serializeAws_restXmlDeleteBucketReplicationCommand, } from "../protocols/Aws_restXml";
var DeleteBucketReplicationCommand = (function (_super) {
    __extends(DeleteBucketReplicationCommand, _super);
    function DeleteBucketReplicationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteBucketReplicationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "DeleteBucketReplicationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteBucketReplicationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteBucketReplicationCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlDeleteBucketReplicationCommand(input, context);
    };
    DeleteBucketReplicationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlDeleteBucketReplicationCommand(output, context);
    };
    return DeleteBucketReplicationCommand;
}($Command));
export { DeleteBucketReplicationCommand };
