import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteBucketPolicyRequest } from "../models/models_0";
import { deserializeAws_restXmlDeleteBucketPolicyCommand, serializeAws_restXmlDeleteBucketPolicyCommand, } from "../protocols/Aws_restXml";
var DeleteBucketPolicyCommand = (function (_super) {
    __extends(DeleteBucketPolicyCommand, _super);
    function DeleteBucketPolicyCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteBucketPolicyCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "DeleteBucketPolicyCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteBucketPolicyRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteBucketPolicyCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlDeleteBucketPolicyCommand(input, context);
    };
    DeleteBucketPolicyCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlDeleteBucketPolicyCommand(output, context);
    };
    return DeleteBucketPolicyCommand;
}($Command));
export { DeleteBucketPolicyCommand };
