import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteBucketMetricsConfigurationRequest } from "../models/models_0";
import { deserializeAws_restXmlDeleteBucketMetricsConfigurationCommand, serializeAws_restXmlDeleteBucketMetricsConfigurationCommand, } from "../protocols/Aws_restXml";
var DeleteBucketMetricsConfigurationCommand = (function (_super) {
    __extends(DeleteBucketMetricsConfigurationCommand, _super);
    function DeleteBucketMetricsConfigurationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteBucketMetricsConfigurationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "DeleteBucketMetricsConfigurationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteBucketMetricsConfigurationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteBucketMetricsConfigurationCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlDeleteBucketMetricsConfigurationCommand(input, context);
    };
    DeleteBucketMetricsConfigurationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlDeleteBucketMetricsConfigurationCommand(output, context);
    };
    return DeleteBucketMetricsConfigurationCommand;
}($Command));
export { DeleteBucketMetricsConfigurationCommand };
