import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteBucketLifecycleRequest } from "../models/models_0";
import { deserializeAws_restXmlDeleteBucketLifecycleCommand, serializeAws_restXmlDeleteBucketLifecycleCommand, } from "../protocols/Aws_restXml";
var DeleteBucketLifecycleCommand = (function (_super) {
    __extends(DeleteBucketLifecycleCommand, _super);
    function DeleteBucketLifecycleCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteBucketLifecycleCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "DeleteBucketLifecycleCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteBucketLifecycleRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteBucketLifecycleCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlDeleteBucketLifecycleCommand(input, context);
    };
    DeleteBucketLifecycleCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlDeleteBucketLifecycleCommand(output, context);
    };
    return DeleteBucketLifecycleCommand;
}($Command));
export { DeleteBucketLifecycleCommand };
