import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteBucketIntelligentTieringConfigurationRequest } from "../models/models_0";
import { deserializeAws_restXmlDeleteBucketIntelligentTieringConfigurationCommand, serializeAws_restXmlDeleteBucketIntelligentTieringConfigurationCommand, } from "../protocols/Aws_restXml";
var DeleteBucketIntelligentTieringConfigurationCommand = (function (_super) {
    __extends(DeleteBucketIntelligentTieringConfigurationCommand, _super);
    function DeleteBucketIntelligentTieringConfigurationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteBucketIntelligentTieringConfigurationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "DeleteBucketIntelligentTieringConfigurationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteBucketIntelligentTieringConfigurationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteBucketIntelligentTieringConfigurationCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlDeleteBucketIntelligentTieringConfigurationCommand(input, context);
    };
    DeleteBucketIntelligentTieringConfigurationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlDeleteBucketIntelligentTieringConfigurationCommand(output, context);
    };
    return DeleteBucketIntelligentTieringConfigurationCommand;
}($Command));
export { DeleteBucketIntelligentTieringConfigurationCommand };
