import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteBucketCorsRequest } from "../models/models_0";
import { deserializeAws_restXmlDeleteBucketCorsCommand, serializeAws_restXmlDeleteBucketCorsCommand, } from "../protocols/Aws_restXml";
var DeleteBucketCorsCommand = (function (_super) {
    __extends(DeleteBucketCorsCommand, _super);
    function DeleteBucketCorsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteBucketCorsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "DeleteBucketCorsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteBucketCorsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteBucketCorsCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlDeleteBucketCorsCommand(input, context);
    };
    DeleteBucketCorsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlDeleteBucketCorsCommand(output, context);
    };
    return DeleteBucketCorsCommand;
}($Command));
export { DeleteBucketCorsCommand };
