import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteBucketRequest } from "../models/models_0";
import { deserializeAws_restXmlDeleteBucketCommand, serializeAws_restXmlDeleteBucketCommand, } from "../protocols/Aws_restXml";
var DeleteBucketCommand = (function (_super) {
    __extends(DeleteBucketCommand, _super);
    function DeleteBucketCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteBucketCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "DeleteBucketCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteBucketRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteBucketCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlDeleteBucketCommand(input, context);
    };
    DeleteBucketCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlDeleteBucketCommand(output, context);
    };
    return DeleteBucketCommand;
}($Command));
export { DeleteBucketCommand };
