import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeleteBucketAnalyticsConfigurationRequest } from "../models/models_0";
import { deserializeAws_restXmlDeleteBucketAnalyticsConfigurationCommand, serializeAws_restXmlDeleteBucketAnalyticsConfigurationCommand, } from "../protocols/Aws_restXml";
var DeleteBucketAnalyticsConfigurationCommand = (function (_super) {
    __extends(DeleteBucketAnalyticsConfigurationCommand, _super);
    function DeleteBucketAnalyticsConfigurationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DeleteBucketAnalyticsConfigurationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "DeleteBucketAnalyticsConfigurationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DeleteBucketAnalyticsConfigurationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DeleteBucketAnalyticsConfigurationCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlDeleteBucketAnalyticsConfigurationCommand(input, context);
    };
    DeleteBucketAnalyticsConfigurationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlDeleteBucketAnalyticsConfigurationCommand(output, context);
    };
    return DeleteBucketAnalyticsConfigurationCommand;
}($Command));
export { DeleteBucketAnalyticsConfigurationCommand };
