import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { getSsecPlugin } from "@aws-sdk/middleware-ssec";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateMultipartUploadOutput, CreateMultipartUploadRequest } from "../models/models_0";
import { deserializeAws_restXmlCreateMultipartUploadCommand, serializeAws_restXmlCreateMultipartUploadCommand, } from "../protocols/Aws_restXml";
var CreateMultipartUploadCommand = (function (_super) {
    __extends(CreateMultipartUploadCommand, _super);
    function CreateMultipartUploadCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateMultipartUploadCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getSsecPlugin(configuration));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "CreateMultipartUploadCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateMultipartUploadRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateMultipartUploadOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateMultipartUploadCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlCreateMultipartUploadCommand(input, context);
    };
    CreateMultipartUploadCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlCreateMultipartUploadCommand(output, context);
    };
    return CreateMultipartUploadCommand;
}($Command));
export { CreateMultipartUploadCommand };
