import { __extends } from "tslib";
import { getLocationConstraintPlugin } from "@aws-sdk/middleware-location-constraint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateBucketOutput, CreateBucketRequest } from "../models/models_0";
import { deserializeAws_restXmlCreateBucketCommand, serializeAws_restXmlCreateBucketCommand, } from "../protocols/Aws_restXml";
var CreateBucketCommand = (function (_super) {
    __extends(CreateBucketCommand, _super);
    function CreateBucketCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateBucketCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getLocationConstraintPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "CreateBucketCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateBucketRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateBucketOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateBucketCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlCreateBucketCommand(input, context);
    };
    CreateBucketCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlCreateBucketCommand(output, context);
    };
    return CreateBucketCommand;
}($Command));
export { CreateBucketCommand };
