import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getThrow200ExceptionsPlugin } from "@aws-sdk/middleware-sdk-s3";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { getSsecPlugin } from "@aws-sdk/middleware-ssec";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CopyObjectOutput, CopyObjectRequest } from "../models/models_0";
import { deserializeAws_restXmlCopyObjectCommand, serializeAws_restXmlCopyObjectCommand, } from "../protocols/Aws_restXml";
var CopyObjectCommand = (function (_super) {
    __extends(CopyObjectCommand, _super);
    function CopyObjectCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CopyObjectCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getThrow200ExceptionsPlugin(configuration));
        this.middlewareStack.use(getSsecPlugin(configuration));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "CopyObjectCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CopyObjectRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CopyObjectOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CopyObjectCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlCopyObjectCommand(input, context);
    };
    CopyObjectCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlCopyObjectCommand(output, context);
    };
    return CopyObjectCommand;
}($Command));
export { CopyObjectCommand };
