import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getThrow200ExceptionsPlugin } from "@aws-sdk/middleware-sdk-s3";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { getSsecPlugin } from "@aws-sdk/middleware-ssec";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CompleteMultipartUploadOutput, CompleteMultipartUploadRequest } from "../models/models_0";
import { deserializeAws_restXmlCompleteMultipartUploadCommand, serializeAws_restXmlCompleteMultipartUploadCommand, } from "../protocols/Aws_restXml";
var CompleteMultipartUploadCommand = (function (_super) {
    __extends(CompleteMultipartUploadCommand, _super);
    function CompleteMultipartUploadCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CompleteMultipartUploadCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getThrow200ExceptionsPlugin(configuration));
        this.middlewareStack.use(getSsecPlugin(configuration));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "CompleteMultipartUploadCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CompleteMultipartUploadRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CompleteMultipartUploadOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CompleteMultipartUploadCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlCompleteMultipartUploadCommand(input, context);
    };
    CompleteMultipartUploadCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlCompleteMultipartUploadCommand(output, context);
    };
    return CompleteMultipartUploadCommand;
}($Command));
export { CompleteMultipartUploadCommand };
