import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AbortMultipartUploadOutput, AbortMultipartUploadRequest } from "../models/models_0";
import { deserializeAws_restXmlAbortMultipartUploadCommand, serializeAws_restXmlAbortMultipartUploadCommand, } from "../protocols/Aws_restXml";
var AbortMultipartUploadCommand = (function (_super) {
    __extends(AbortMultipartUploadCommand, _super);
    function AbortMultipartUploadCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AbortMultipartUploadCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "AbortMultipartUploadCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AbortMultipartUploadRequest.filterSensitiveLog,
            outputFilterSensitiveLog: AbortMultipartUploadOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AbortMultipartUploadCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlAbortMultipartUploadCommand(input, context);
    };
    AbortMultipartUploadCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlAbortMultipartUploadCommand(output, context);
    };
    return AbortMultipartUploadCommand;
}($Command));
export { AbortMultipartUploadCommand };
