"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getRuntimeConfig = void 0;
const tslib_1 = require("tslib");
const package_json_1 = tslib_1.__importDefault(require("../package.json"));
const sha1_browser_1 = require("@aws-crypto/sha1-browser");
const sha256_browser_1 = require("@aws-crypto/sha256-browser");
const config_resolver_1 = require("@aws-sdk/config-resolver");
const eventstream_serde_browser_1 = require("@aws-sdk/eventstream-serde-browser");
const fetch_http_handler_1 = require("@aws-sdk/fetch-http-handler");
const hash_blob_browser_1 = require("@aws-sdk/hash-blob-browser");
const invalid_dependency_1 = require("@aws-sdk/invalid-dependency");
const md5_js_1 = require("@aws-sdk/md5-js");
const middleware_retry_1 = require("@aws-sdk/middleware-retry");
const util_base64_browser_1 = require("@aws-sdk/util-base64-browser");
const util_body_length_browser_1 = require("@aws-sdk/util-body-length-browser");
const util_stream_browser_1 = require("@aws-sdk/util-stream-browser");
const util_user_agent_browser_1 = require("@aws-sdk/util-user-agent-browser");
const util_utf8_browser_1 = require("@aws-sdk/util-utf8-browser");
const runtimeConfig_shared_1 = require("./runtimeConfig.shared");
const smithy_client_1 = require("@aws-sdk/smithy-client");
const util_defaults_mode_browser_1 = require("@aws-sdk/util-defaults-mode-browser");
const getRuntimeConfig = (config) => {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v;
    const defaultsMode = (0, util_defaults_mode_browser_1.resolveDefaultsModeConfig)(config);
    const defaultConfigProvider = () => defaultsMode().then(smithy_client_1.loadConfigsForDefaultMode);
    const clientSharedValues = (0, runtimeConfig_shared_1.getRuntimeConfig)(config);
    return {
        ...clientSharedValues,
        ...config,
        runtime: "browser",
        defaultsMode,
        base64Decoder: (_a = config === null || config === void 0 ? void 0 : config.base64Decoder) !== null && _a !== void 0 ? _a : util_base64_browser_1.fromBase64,
        base64Encoder: (_b = config === null || config === void 0 ? void 0 : config.base64Encoder) !== null && _b !== void 0 ? _b : util_base64_browser_1.toBase64,
        bodyLengthChecker: (_c = config === null || config === void 0 ? void 0 : config.bodyLengthChecker) !== null && _c !== void 0 ? _c : util_body_length_browser_1.calculateBodyLength,
        credentialDefaultProvider: (_d = config === null || config === void 0 ? void 0 : config.credentialDefaultProvider) !== null && _d !== void 0 ? _d : ((_) => () => Promise.reject(new Error("Credential is missing"))),
        defaultUserAgentProvider: (_e = config === null || config === void 0 ? void 0 : config.defaultUserAgentProvider) !== null && _e !== void 0 ? _e : (0, util_user_agent_browser_1.defaultUserAgent)({ serviceId: clientSharedValues.serviceId, clientVersion: package_json_1.default.version }),
        eventStreamSerdeProvider: (_f = config === null || config === void 0 ? void 0 : config.eventStreamSerdeProvider) !== null && _f !== void 0 ? _f : eventstream_serde_browser_1.eventStreamSerdeProvider,
        getAwsChunkedEncodingStream: (_g = config === null || config === void 0 ? void 0 : config.getAwsChunkedEncodingStream) !== null && _g !== void 0 ? _g : util_stream_browser_1.getAwsChunkedEncodingStream,
        maxAttempts: (_h = config === null || config === void 0 ? void 0 : config.maxAttempts) !== null && _h !== void 0 ? _h : middleware_retry_1.DEFAULT_MAX_ATTEMPTS,
        md5: (_j = config === null || config === void 0 ? void 0 : config.md5) !== null && _j !== void 0 ? _j : md5_js_1.Md5,
        region: (_k = config === null || config === void 0 ? void 0 : config.region) !== null && _k !== void 0 ? _k : (0, invalid_dependency_1.invalidProvider)("Region is missing"),
        requestHandler: (_l = config === null || config === void 0 ? void 0 : config.requestHandler) !== null && _l !== void 0 ? _l : new fetch_http_handler_1.FetchHttpHandler(defaultConfigProvider),
        retryMode: (_m = config === null || config === void 0 ? void 0 : config.retryMode) !== null && _m !== void 0 ? _m : (async () => (await defaultConfigProvider()).retryMode || middleware_retry_1.DEFAULT_RETRY_MODE),
        sha1: (_o = config === null || config === void 0 ? void 0 : config.sha1) !== null && _o !== void 0 ? _o : sha1_browser_1.Sha1,
        sha256: (_p = config === null || config === void 0 ? void 0 : config.sha256) !== null && _p !== void 0 ? _p : sha256_browser_1.Sha256,
        streamCollector: (_q = config === null || config === void 0 ? void 0 : config.streamCollector) !== null && _q !== void 0 ? _q : fetch_http_handler_1.streamCollector,
        streamHasher: (_r = config === null || config === void 0 ? void 0 : config.streamHasher) !== null && _r !== void 0 ? _r : hash_blob_browser_1.blobHasher,
        useDualstackEndpoint: (_s = config === null || config === void 0 ? void 0 : config.useDualstackEndpoint) !== null && _s !== void 0 ? _s : (() => Promise.resolve(config_resolver_1.DEFAULT_USE_DUALSTACK_ENDPOINT)),
        useFipsEndpoint: (_t = config === null || config === void 0 ? void 0 : config.useFipsEndpoint) !== null && _t !== void 0 ? _t : (() => Promise.resolve(config_resolver_1.DEFAULT_USE_FIPS_ENDPOINT)),
        utf8Decoder: (_u = config === null || config === void 0 ? void 0 : config.utf8Decoder) !== null && _u !== void 0 ? _u : util_utf8_browser_1.fromUtf8,
        utf8Encoder: (_v = config === null || config === void 0 ? void 0 : config.utf8Encoder) !== null && _v !== void 0 ? _v : util_utf8_browser_1.toUtf8,
    };
};
exports.getRuntimeConfig = getRuntimeConfig;
