import { fromBase64 } from "@aws-sdk/util-base64-browser";
export function blobReader(blob, onChunk, chunkSize) {
    if (chunkSize === void 0) { chunkSize = 1024 * 1024; }
    return new Promise(function (resolve, reject) {
        var fileReader = new FileReader();
        fileReader.onerror = reject;
        fileReader.onabort = reject;
        var size = blob.size;
        var totalBytesRead = 0;
        var read = function () {
            if (totalBytesRead >= size) {
                resolve();
                return;
            }
            fileReader.readAsDataURL(blob.slice(totalBytesRead, Math.min(size, totalBytesRead + chunkSize)));
        };
        fileReader.onload = function (event) {
            var result = event.target.result;
            var dataOffset = result.indexOf(",") + 1;
            var data = result.substring(dataOffset);
            var decoded = fromBase64(data);
            onChunk(decoded);
            totalBytesRead += decoded.byteLength;
            read();
        };
        read();
    });
}
